CREATE TABLE names (
  id integer PRIMARY KEY,
  canonical text NOT NULL,
  authorship text,
  datepublished text,
  originalcitation text,
  status text,
  classification text,
  phylum text,
  class_ text,
  order_ text,
  rank text,
  typestatus text,
  typename text,
  typespecimen text,
  typedesignatedby text,
  typedesignationtype text,
  gender text,
  sic boolean,
  synopsis text,
  direction text,
  opinions integer[],
  rlpcomments text,
  plaintext text
);

CREATE TABLE raw (
  id integer PRIMARY KEY REFERENCES names (id),
  parentid integer,
  monomial text,
  epithet text,
  infraepithet text,
  rankmarker text,
  highertaxon text,
  highertaxon2 text,
  typification text,
  html text,
  parse text,
  paragraph text,
  isbold boolean,
  isitalics boolean,
  firstspan text,
  closefirstspan text,
  firstname text,
  firstnamecomment text,
  isbold2 boolean,
  isitalics2 boolean,
  secondspan text,
  secondname text,
  secondnamecomment text
);

CREATE TABLE opinion (
  number integer NOT NULL,
  isaddendum boolean,
  volume text,
  pages text,
  journal text,
  type text,
  startdate date,
  enddate date
);